//=============================================================================
// GreaselPet.
//=============================================================================
class SpiderPet extends DeusExPickup;

var localized String MsgNoHALP;

state Activated
{
	function Activate()
	{
	}

	function BeginState()
	{
		local DeusExPlayer P;
                		local Vector loc;
		local SpiderCompanion D;
	
		Super.BeginState(); 

                		P = DeusExPlayer(Owner);
                		if ( P != None )    
                		{            
                      		D = Spawn(Class'SpiderCompanion',P,,P.Location + (P.CollisionRadius+Class'DragonCompanion'.Default.CollisionRadius+30) * Vector(P.ViewRotation) + vect(0,0,1) * 30 );
			if ( D != None )
			{
                      			D.PlaySound(None);
                      			UseOnce();
			}
			else
			{
				P.ClientMessage(MsgNoHALP);
				GotoState('DeActivated');
			}
                		}
	}
Begin:
}

defaultproperties
{
     MsgNoHALP="|p2Spider cannot be released here."
     bActivatable=True
     ItemName="Spider Pet"
     PlayerViewOffset=(X=20.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'Markistan.Spider'
     PlayerViewScale=0.800000
     PickupViewMesh=LodMesh'Markistan.Spider'
     ThirdPersonMesh=LodMesh'Markistan.Spider'
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'Markistan.Icons.BeltIconHALPAgent'
     largeIcon=Texture'Markistan.Icons.InventoryIconHALPAgent'
     largeIconWidth=49
     largeIconHeight=49
     Description="A small spider that seems to like you..."
     beltDescription="Spider"
     Mesh=LodMesh'Markistan.Spider'
     CollisionRadius=16.790001
     CollisionHeight=7.620000
     Mass=50.000000
     Buoyancy=100.000000
}
